<?php
/***************************************************************************
 *
 *  Attachment Downloads Log (/inc/plugins/attachmentlog.php)
 *  Author: Pirata Nervo
 *  Copyright: © 2009-2010 Pirata Nervo
 *  
 *  Website: http://consoleworld.net
 *  License: license.txt
 *
 *  Logs who downloads attachments.
 *
 ***************************************************************************/

/****************************************************************************
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/

if(!defined("IN_MYBB"))
	die("This file cannot be accessed directly.");

// add hooks
$plugins->add_hook('admin_load', 'attachmentlog_admin');
$plugins->add_hook('admin_tools_menu', 'attachmentlog_admin_tools_menu');
$plugins->add_hook('admin_tools_action_handler', 'attachmentlog_admin_tools_action_handler');
$plugins->add_hook('admin_tools_permissions', 'attachmentlog_admin_permissions');

$plugins->add_hook('attachment_end', 'attachmentlog_log');

function attachmentlog_info()
{
	return array(
		"name"			=> "هاك سجلات المرفقات",
		"description"	=> "يعمل علي اظهار سجلات المرفقات بشكل منظم لمعرفة تفاصيل عنها",
		"website"		=> "http://mybb-plugins.com",
		"author"		=> "Pirata Nervo",
		"authorsite"	=> "http://consoleaddicted.com",
		"version"		=> "1.1",
		"guid" 			=> "ac6ebb542d35f0b99c2e3d6e8093e8b1",
		"compatibility"	=> "16*"
	);
}


function attachmentlog_activate()
{
	global $db, $lang;
	// create settings group
	$insertarray = array(
		'name' => 'attachmentlog', 
		'title' => 'سجل تحميل المرفقات', 
		'description' => "اعدادات هاك سجل المرفقات", 
		'disporder' => 100, 
		'isdefault' => 0
	);
	$gid = $db->insert_query("settinggroups", $insertarray);
	
	// add settings
	$setting0 = array(
		"sid"			=> NULL,
		"name"			=> "attachmentlog_forums",
		"title"			=> "الغاء اقسام",
		"description"	=> "ان اردت عدم حفظ سجلات لقسم ما فضع رقم القسم هنا",
		"optionscode"	=> "text",
		"value"			=> "",
		"disporder"		=> 1,
		"gid"			=> $gid
	);

	$db->insert_query("settings", $setting0);
	
	$setting1 = array(
		"sid"			=> NULL,
		"name"			=> "attachmentlog_groups",
		"title"			=> "الغاء مجموعات",
		"description"	=> "ان اردت عدم حفظ سجلات لمجموعة معينه من مجموعات الاعضاء فضع رقم المجموعة هنا",
		"optionscode"	=> "text",
		"value"			=> "",
		"disporder"		=> 2,
		"gid"			=> $gid
	);

	$db->insert_query("settings", $setting1);
	
	rebuild_settings();
	
	$db->write_query("CREATE TABLE `".TABLE_PREFIX."attachmentlog` (
	  `lid` bigint(30) UNSIGNED NOT NULL auto_increment,
	  `aid` bigint(30) UNSIGNED NOT NULL default '0',
	  `uid` bigint(30) UNSIGNED NOT NULL default '0',
	  `date` bigint(30) UNSIGNED NOT NULL default '0',
	  `atname` varchar(255) NOT NULL default '',
	  `username` varchar(100) NOT NULL default '',
	  PRIMARY KEY  (`lid`)
		) ENGINE = MyISAM");
}


function attachmentlog_deactivate()
{
	global $db, $mybb;
	// delete settings group
	$db->delete_query("settinggroups", "name = 'attachmentlog'");

	// remove settings
	$db->delete_query('settings', 'name IN ( \'attachmentlog_forums\',\'attachmentlog_groups\')');

	rebuild_settings();

	if ($db->table_exists('attachmentlog'))
		$db->drop_table('attachmentlog');
}

/* Checks if the primary or any of the additional groups of the current user are in the groups list passed as a parameter
 * @param String group ids seperated by a comma
 * @return true if the user has permissions, false if not
*/
function attachmentlog_check_permissions($groups_comma)
{
    global $mybb;
    
    if ($groups_comma == '')
        return false;
    
    $groups = explode(",", $groups_comma);
    $add_groups = explode(",", $mybb->user['additionalgroups']);
    
    if (!in_array($mybb->user['usergroup'], $groups)) { // primary user group not allowed
        // check additional groups
        if ($add_groups) {
            if (count(array_intersect($add_groups, $groups)) == 0)
                return false;
            else
                return true;
        }
        else 
            return false;
    }
    else
        return true;
} 

function attachmentlog_log()
{
	global $aid, $mybb, $db, $lang, $thread, $fid, $tid, $attachment;
	
	// thumbnails don't count
	if ($mybb->input['thumbnail'])
		return;
	
	$affected_fids = explode(',', $mybb->settings['attachmentlog_forums']);
	if (in_array($fid, $affected_fids))
		return;
		
	if (attachmentlog_check_permissions($mybb->settings['attachmentlog_groups']))
		return;
		
	if (!$mybb->user['username'])
		$mybb->user['username'] = 'Guest';
		
	// log download
	$insert_array = array(
		'aid' => intval($aid),
		'uid' => intval($mybb->user['uid']),
		'username' => $db->escape_string($mybb->user['username']),
		'date' => TIME_NOW,
		'atname' => $db->escape_string($attachment['filename'])
	);
	$db->insert_query('attachmentlog', $insert_array);
}

function attachmentlog_get_username($uid)
{
	global $db;
	$query = $db->simple_select('users', 'username', 'uid=\''.intval($uid).'\'', 1);
	return $db->fetch_field($query, 'username');
}

function attachmentlog_get_uid($username)
{
	global $db;
	$query = $db->simple_select('users', 'uid', 'username=\''.$db->escape_string($username).'\'', 1);
	return $db->fetch_field($query, 'uid');
}

/*************************************************************************************/
// ADMIN PART
/*************************************************************************************/

function attachmentlog_admin_tools_menu(&$sub_menu)
{
	global $lang;
	
	$lang->load('attachmentlog');
	$sub_menu[] = array('id' => 'attachmentlog', 'title' => $lang->attachmentlog_index, 'link' => 'index.php?module=tools-attachmentlog');
}

function attachmentlog_admin_tools_action_handler(&$actions)
{
	$actions['attachmentlog'] = array('active' => 'attachmentlog', 'file' => 'attachmentlog');
}

function attachmentlog_admin_permissions(&$admin_permissions)
{
  	global $db, $mybb, $lang;
  
	$lang->load("attachmentlog", false, true);
	$admin_permissions['attachmentlog'] = $lang->attachmentlog_canmanage;
	
}

function attachmentlog_admin()
{
	global $db, $lang, $mybb, $page, $run_module, $action_file, $mybbadmin, $plugins;
	
	$lang->load("attachmentlog", false, true);
	
	if($run_module == 'tools' && $action_file == 'attachmentlog')
	{
		if (!$mybb->input['action'])
		{
			$page->add_breadcrumb_item($lang->attachmentlog, 'index.php?module=tools-attachmentlog');
						
			$page->output_header($lang->attachmentlog);
				
			$sub_tabs['attachmentlog_downloads'] = array(
				'title'			=> $lang->attachmentlog_downloads,
				'link'			=> 'index.php?module=tools-attachmentlog',
				'description'	=> $lang->attachmentlog_downloads_desc
			);
		}
		
		if (!$mybb->input['action'])
		{
			$page->output_nav_tabs($sub_tabs, 'attachmentlog_downloads');
			
			// pagination
			$per_page = 15;
			if($mybb->input['page'] && intval($mybb->input['page']) > 1)
			{
				$mybb->input['page'] = intval($mybb->input['page']);
				$start = ($mybb->input['page']*$per_page)-$per_page;
			}
			else
			{
				$mybb->input['page'] = 1;
				$start = 0;
			}
			
			$query = $db->simple_select("attachmentlog", "COUNT(lid) as logs");
			$total_rows = $db->fetch_field($query, "logs");
		
			echo "<br />".draw_admin_pagination($mybb->input['page'], $per_page, $total_rows, "index.php?module=tools-attachmentlog&amp;page={page}");
			
			// table
			$table = new Table;
			$table->construct_header($lang->attachmentlog_downloads_user, array('width' => '30%'));
			$table->construct_header($lang->attachmentlog_downloads_attachment, array('width' => '30%'));
			$table->construct_header($lang->attachmentlog_downloads_date, array('width' => '20%', 'class' => 'align_center'));
			$table->construct_header($lang->attachmentlog_downloads_options, array('width' => '20%', 'class' => 'align_center'));
			
			$query = $db->query("
				SELECT u.*, u.username AS userusername, l.*
				FROM ".TABLE_PREFIX."attachmentlog l
				LEFT JOIN ".TABLE_PREFIX."users u ON (u.uid=l.uid)
				ORDER BY l.date DESC LIMIT {$start}, {$per_page}
			");
			
			while ($log = $db->fetch_array($query))
			{
				$table->construct_cell(build_profile_link(htmlspecialchars_uni($log['username']), intval($log['uid']))); // user
				$table->construct_cell("<a href=\"".$mybb->settings['bburl']."/attachment.php?aid=".intval($log['aid'])."\">".htmlspecialchars_uni($log['atname'])."</a>"); // attachment
				$table->construct_cell(my_date($mybb->settings['dateformat'], intval($log['date']), '', false).", ".my_date($mybb->settings['timeformat'], intval($log['date'])), array('class' => 'align_center')); // date
				
				// options column
				$table->construct_cell("<a href=\"index.php?module=tools-attachmentlog&amp;action=delete_log&amp;lid=".intval($log['lid'])."\">".$lang->attachmentlog_delete."</a>", array('class' => 'align_center'));
				$table->construct_row();
			}
			
			if($table->num_rows() == 0)
			{
				$table->construct_cell($lang->attachmentlog_nodownloads, array('colspan' => 4));
				
				$table->construct_row();
			}
			
			$table->output($lang->attachmentlog_downloads);
			
			echo "<br />";
	
			$form = new Form("index.php?module=tools-attachmentlog&amp;action=prune", "post", "newpoints");
			
			echo $form->generate_hidden_field("my_post_key", $mybb->post_code);
				
			$form_container = new FormContainer($lang->attachmentlog_prune);
			$form_container->output_row($lang->attachmentlog_prune_days, $lang->attachmentlog_prune_days_desc, $form->generate_text_box('days', 30, array('id' => 'days')), 'days');
			$form_container->end();
		
			$buttons = array();;
			$buttons[] = $form->generate_submit_button($lang->attachmentlog_submit);
			$buttons[] = $form->generate_reset_button($lang->attachmentlog_reset);
			$form->output_submit_wrapper($buttons);
			$form->end();
			
		}
		elseif ($mybb->input['action'] == 'delete_log')
		{
			if($mybb->input['no']) // user clicked no
			{
				admin_redirect("index.php?module=tools-attachmentlog");
			}
		
			if($mybb->request_method == "post")
			{
				if(!isset($mybb->input['my_post_key']) || $mybb->post_code != $mybb->input['my_post_key'])
				{
					$mybb->request_method = "get";
					flash_message($lang->attachmentlog_error, 'error');
					admin_redirect("index.php?module=tools-attachmentlog");
				}
				
				if (!$db->fetch_field($db->simple_select('attachmentlog', 'aid', 'lid='.intval($mybb->input['lid']), array('limit' => 1)), 'aid'))
				{
					flash_message($lang->attachmentlog_log_invalid, 'error');
					admin_redirect('index.php?module=tools-attachmentlog');
				}
				else {																				 
					$db->delete_query('attachmentlog', 'lid='.intval($mybb->input['lid']));
					flash_message($lang->attachmentlog_log_deleted, 'success');
					admin_redirect('index.php?module=tools-attachmentlog');
				}
			}
			else
			{
				$page->add_breadcrumb_item($lang->attachmentlog_downloads, 'index.php?module=tools-attachmentlog');
					
				$page->output_header($lang->attachmentlog_downloads);
				
				$mybb->input['lid'] = intval($mybb->input['lid']);
				$form = new Form("index.php?module=tools-attachmentlog&amp;action=delete_log&amp;lid={$mybb->input['lid']}&amp;my_post_key={$mybb->post_code}", 'post');
				echo "<div class=\"confirm_action\">\n";
				echo "<p>{$lang->attachmentlog_downloads_deleteconfirm}</p>\n";
				echo "<br />\n";
				echo "<p class=\"buttons\">\n";
				echo $form->generate_submit_button($lang->yes, array('class' => 'button_yes'));
				echo $form->generate_submit_button($lang->no, array("name" => "no", 'class' => 'button_no'));
				echo "</p>\n";
				echo "</div>\n";
				$form->end();
			}
		}
		elseif ($mybb->input['action'] == 'prune')
		{
			if($mybb->input['no']) // user clicked no
			{
				admin_redirect("index.php?module=tools-attachmentlog");
			}
		
			if($mybb->request_method == "post")
			{
				if(!isset($mybb->input['my_post_key']) || $mybb->post_code != $mybb->input['my_post_key'])
				{
					$mybb->request_method = "get";
					flash_message($lang->attachmentlog_error, 'error');
					admin_redirect("index.php?module=tools-attachmentlog");
				}
				
				$db->delete_query('attachmentlog', 'date < '.(TIME_NOW - intval($mybb->input['days'])*60*60*24));
				flash_message($lang->attachmentlog_log_pruned, 'success');
				admin_redirect('index.php?module=tools-attachmentlog');
			}
			else
			{
				$page->add_breadcrumb_item($lang->attachmentlog_downloads, 'index.php?module=tools-attachmentlog');
					
				$page->output_header($lang->attachmentlog_downloads);
				
				$mybb->input['days'] = intval($mybb->input['days']);
				$form = new Form("index.php?module=tools-attachmentlog&amp;action=prune&amp;days={$mybb->input['days']}&amp;my_post_key={$mybb->post_code}", 'post');
				echo "<div class=\"confirm_action\">\n";
				echo "<p>{$lang->attachmentlog_downloads_pruneconfirm}</p>\n";
				echo "<br />\n";
				echo "<p class=\"buttons\">\n";
				echo $form->generate_submit_button($lang->yes, array('class' => 'button_yes'));
				echo $form->generate_submit_button($lang->no, array("name" => "no", 'class' => 'button_no'));
				echo "</p>\n";
				echo "</div>\n";
				$form->end();
			}
		}
		
		$page->output_footer();
		exit;
	}
}

?>
